<?php
/**
 * Plugin Name: WhatsApp WooCommerce Waappir
 * Plugin URI: https://panel.waapp.ir/docs#plugins
 * Description: اتصال ووکامرس به وب‌سرویس واتساپ با تنظیمات اختصاصی.
 * Version: 1.0.1
 * Author: waapp.ir
 * Author URI: https://waapp.ir
 * Text Domain: waappir
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! defined( 'WC_WHATSAPP_WAAPPIr_VERSION' ) ) {
    define( 'WC_WHATSAPP_WAAPPIr_VERSION', '1.0.1' );
}

if ( ! defined( 'WC_WHATSAPP_WAAPPIr_PLUGIN_FILE' ) ) {
    define( 'WC_WHATSAPP_WAAPPIr_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'WC_WHATSAPP_WAAPPIr_PLUGIN_PATH' ) ) {
    define( 'WC_WHATSAPP_WAAPPIr_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'WC_WHATSAPP_WAAPPIr_PLUGIN_URL' ) ) {
    define( 'WC_WHATSAPP_WAAPPIr_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

/**
 * Display admin notice if WooCommerce is not active.
 */
function wc_whatsapp_waappir_missing_wc_notice() {
    echo '<div class="notice notice-error"><p>' . esc_html__( 'برای استفاده از افزونه WhatsApp WooCommerce Waappir باید افزونه ووکامرس فعال باشد.', 'wc-whatsapp-waappir' ) . '</p></div>';
}

/**
 * Init plugin after plugins are loaded.
 */
function wc_whatsapp_waappir_init_plugin() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', 'wc_whatsapp_waappir_missing_wc_notice' );
        return;
    }

    require_once WC_WHATSAPP_WAAPPIr_PLUGIN_PATH . 'includes/class-wc-whatsapp-waappir.php';

    WC_WhatsApp_Waappir::instance();
}
add_action( 'plugins_loaded', 'wc_whatsapp_waappir_init_plugin', 20 );

/**
 * Activation hook.
 */
function wc_whatsapp_waappir_activate() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        deactivate_plugins( plugin_basename( __FILE__ ) );
        wp_die( esc_html__( 'برای فعال‌سازی افزونه WhatsApp WooCommerce Waappir باید ووکامرس فعال باشد.', 'wc-whatsapp-waappir' ) );
    }
}
register_activation_hook( __FILE__, 'wc_whatsapp_waappir_activate' );
