<?php
/**
 * Uninstall script for WhatsApp WooCommerce.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Delete plugin options.
$option_keys = array(
    'wc_whatsapp_waappir_enabled',
    'wc_whatsapp_waappir_auth_token',
    'wc_whatsapp_waappir_admin_enabled',
    'wc_whatsapp_waappir_admin_phone',
    'wc_whatsapp_waappir_admin_statuses',
    'wc_whatsapp_waappir_admin_low_stock',
    'wc_whatsapp_waappir_admin_out_stock',
    'wc_whatsapp_waappir_customer_enabled',
    'wc_whatsapp_waappir_customer_new_order_enabled',
    'wc_whatsapp_waappir_customer_new_order_msg',
    'wc_whatsapp_waappir_customer_statuses',
);

foreach ( $option_keys as $key ) {
    delete_option( $key );
}

// Delete dynamic status message options
$order_statuses = function_exists( 'wc_get_order_statuses' ) ? wc_get_order_statuses() : array();
foreach ( $order_statuses as $status_key => $status_label ) {
    $clean_status = str_replace( 'wc-', '', $status_key );
    delete_option( 'wc_whatsapp_waappir_admin_msg_' . $clean_status );
    delete_option( 'wc_whatsapp_waappir_customer_msg_' . $clean_status );
}
