<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WC_WhatsApp_Waappir {

    /**
     * Singleton instance.
     *
     * @var WC_WhatsApp_Waappir
     */
    protected static $instance = null;

    /**
     * Get singleton instance.
     *
     * @return WC_WhatsApp_Waappir
     */
    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * WC_WhatsApp constructor.
     */
    public function __construct() {
        $this->includes();
        $this->init_hooks();
    }

    /**
     * Include required files.
     */
    protected function includes() {
        require_once WC_WHATSAPP_WAAPPIr_PLUGIN_PATH . 'includes/class-wc-whatsapp-waappir-settings-tab.php';
        require_once WC_WHATSAPP_WAAPPIr_PLUGIN_PATH . 'includes/class-wc-whatsapp-waappir-admin-page.php';
        require_once WC_WHATSAPP_WAAPPIr_PLUGIN_PATH . 'includes/class-wc-whatsapp-waappir-messenger.php';
        require_once WC_WHATSAPP_WAAPPIr_PLUGIN_PATH . 'includes/class-wc-whatsapp-waappir-admin-assets.php';
        require_once WC_WHATSAPP_WAAPPIr_PLUGIN_PATH . 'includes/class-wc-whatsapp-waappir-shortcode-processor.php';
        require_once WC_WHATSAPP_WAAPPIr_PLUGIN_PATH . 'includes/class-wc-whatsapp-waappir-order-handler.php';
        require_once WC_WHATSAPP_WAAPPIr_PLUGIN_PATH . 'includes/class-wc-whatsapp-waappir-stock-handler.php';
    }

    /**
     * Init hooks.
     */
    protected function init_hooks() {
        // WooCommerce settings tab.
        add_filter( 'woocommerce_get_settings_pages', array( $this, 'register_settings_page' ) );

        // Admin menu page.
        add_action( 'admin_menu', array( $this, 'register_admin_menu' ), 99 );

        // Admin assets.
        add_action( 'admin_enqueue_scripts', array( 'WC_WhatsApp_Waappir_Admin_Assets', 'enqueue_assets' ) );

        // Initialize order and stock handlers
        add_action( 'init', array( $this, 'init_handlers' ) );
    }

    /**
     * Initialize order and stock handlers.
     */
    public function init_handlers() {
        // Initialize order status change handler
        WC_WhatsApp_Waappir_Order_Handler::init();

        // Initialize stock management handler
        WC_WhatsApp_Waappir_Stock_Handler::init();
    }

    /**
     * Register WooCommerce settings page/tab.
     *
     * @param array $settings
     *
     * @return array
     */
    public function register_settings_page( $settings ) {
        if ( ! class_exists( 'WC_WhatsApp_Waappir_Settings_Tab' ) ) {
            return $settings;
        }

        $settings[] = new WC_WhatsApp_Waappir_Settings_Tab();

        return $settings;
    }

    /**
     * Register admin submenu under WooCommerce.
     */
    public function register_admin_menu() {
        if ( ! current_user_can( 'manage_woocommerce' ) ) {
            return;
        }

        add_submenu_page(
            'woocommerce',
            __( 'پیکربندی واتساپ وااپ', 'wc-whatsapp-waappir' ),
            __( 'پیکربندی واتساپ وااپ', 'wc-whatsapp-waappir' ),
            'manage_woocommerce',
            'wc-whatsapp-waappir-settings',
            array( 'WC_WhatsApp_Waappir_Admin_Page', 'render_page' )
        );
    }
}
