<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WC_WhatsApp_Waappir_Stock_Handler {

    /**
     * Initialize stock handler hooks.
     */
    public static function init() {
        // Hook into low stock notification
        add_action( 'woocommerce_low_stock', array( __CLASS__, 'handle_low_stock' ) );

        // Hook into out of stock notification
        add_action( 'woocommerce_no_stock', array( __CLASS__, 'handle_out_of_stock' ) );
    }

    /**
     * Handle low stock notification.
     *
     * @param WC_Product $product
     */
    public static function handle_low_stock( $product ) {
        // Check if WhatsApp service is enabled
        if ( 'yes' !== get_option( 'wc_whatsapp_waappir_enabled', 'no' ) ) {
            return;
        }

        // Check if admin notifications are enabled
        if ( 'yes' !== get_option( 'wc_whatsapp_waappir_admin_enabled', 'no' ) ) {
            return;
        }

        // Get admin phone
        $admin_phone = get_option( 'wc_whatsapp_waappir_admin_phone', '' );
        if ( empty( $admin_phone ) ) {
            return;
        }

        // Get low stock message template
        $message_template = get_option( 'wc_whatsapp_waappir_admin_low_stock', '' );
        if ( empty( $message_template ) ) {
            // Default message if template is empty
            $message_template = 'موجودی محصول {product_name} (کد: {product_sku}) کم است. موجودی فعلی: {stock_qty}';
        }

        // Process shortcodes
        $message = WC_WhatsApp_Waappir_Shortcode_Processor::process_stock_message( $message_template, $product );

        // Send message
        WC_WhatsApp_Waappir_Messenger::send_message_via_api( $admin_phone, $message );
    }

    /**
     * Handle out of stock notification.
     *
     * @param WC_Product $product
     */
    public static function handle_out_of_stock( $product ) {
        // Check if WhatsApp service is enabled
        if ( 'yes' !== get_option( 'wc_whatsapp_waappir_enabled', 'no' ) ) {
            return;
        }

        // Check if admin notifications are enabled
        if ( 'yes' !== get_option( 'wc_whatsapp_waappir_admin_enabled', 'no' ) ) {
            return;
        }

        // Get admin phone
        $admin_phone = get_option( 'wc_whatsapp_waappir_admin_phone', '' );
        if ( empty( $admin_phone ) ) {
            return;
        }

        // Get out of stock message template
        $message_template = get_option( 'wc_whatsapp_waappir_admin_out_stock', '' );
        if ( empty( $message_template ) ) {
            // Default message if template is empty
            $message_template = 'موجودی محصول {product_name} (کد: {product_sku}) تمام شده است!';
        }

        // Process shortcodes
        $message = WC_WhatsApp_Waappir_Shortcode_Processor::process_stock_message( $message_template, $product );

        // Send message
        WC_WhatsApp_Waappir_Messenger::send_message_via_api( $admin_phone, $message );
    }
}