<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'WC_Settings_Page' ) ) {
    return;
}

class WC_WhatsApp_Waappir_Settings_Tab extends WC_Settings_Page {

    public function __construct() {
        $this->id    = 'wc_whatsapp_waappir';
        $this->label = __( 'اتصال به واتساپ ووکامرس', 'wc-whatsapp-waappir' );

        parent::__construct();
    }

    /**
     * Get settings array.
     *
     * @param string $current_section
     *
     * @return array
     */
    public function get_settings( $current_section = '' ) {
        $settings = array(
            'section_title' => array(
                'name' => __( 'تنظیمات اتصال واتساپ', 'wc-whatsapp-waappir' ),
                'type' => 'title',
                'id'   => 'wc_whatsapp_waappir_section_title',
            ),

            'enabled' => array(
                'name' => __( 'فعال سازی وب‌سرویس', 'wc-whatsapp-waappir' ),
                'type' => 'checkbox',
                'id'   => 'wc_whatsapp_waappir_enabled',
                'desc' => __( 'فعال یا غیرفعال کردن اتصال به وب‌سرویس واتساپ.', 'wc-whatsapp-waappir' ),
            ),

            'api_url' => array(
                'name' => __( 'آدرس وب‌سرویس', 'wc-whatsapp-waappir' ),
                'type' => 'text',
                'id'   => 'wc_whatsapp_waappir_api_url',
                'desc' => __( 'مثال: http://localhost:8000/api/v1/send', 'wc-whatsapp-waappir' ),
                'default' => 'http://localhost:8000/api/v1/send',
            ),

            'auth_token' => array(
                'name' => __( 'Authorization (توکن)', 'wc-whatsapp-waappir' ),
                'type' => 'password',
                'id'   => 'wc_whatsapp_waappir_auth_token',
                'desc' => __( 'توکن دسترسی برای هدر Authorization.', 'wc-whatsapp-waappir' ),
            ),

            'section_end' => array(
                'type' => 'sectionend',
                'id'   => 'wc_whatsapp_waappir_section_end',
            ),
        );

        return apply_filters( 'wc_whatsapp_waappir_settings', $settings, $current_section );
    }
}
