<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WC_WhatsApp_Waappir_Admin_Assets {

    /**
     * Enqueue admin styles and scripts.
     *
     * @param string $hook_suffix
     */
    public static function enqueue_assets( $hook_suffix ) {
        // Only load on WooCommerce settings and our custom page.
        $screen = get_current_screen();
        if ( ! $screen ) {
            return;
        }

        if ( false === strpos( $screen->id, 'woocommerce_page_wc-whatsapp-waappir-settings' ) && false === strpos( $screen->id, 'woocommerce_page_wc-settings' ) ) {
            return;
        }

        wp_enqueue_style(
            'wc-whatsapp-waappir-admin',
            WC_WHATSAPP_WAAPPIr_PLUGIN_URL . 'admin/css/admin.css',
            array(),
            WC_WHATSAPP_WAAPPIr_VERSION
        );

        wp_enqueue_script(
            'wc-whatsapp-waappir-admin',
            WC_WHATSAPP_WAAPPIr_PLUGIN_URL . 'admin/js/admin.js',
            array( 'jquery' ),
            WC_WHATSAPP_WAAPPIr_VERSION,
            true
        );
    }
}
