# افزونه WhatsApp WooCommerce

افزونه اتصال ووکامرس به وب‌سرویس واتساپ برای ارسال خودکار پیام به مدیر و مشتریان.

## نسخه 2.1.0

### امکانات جدید نسخه 2.1.0
- **پیام خودکار ثبت سفارش**: ارسال پیام فوری به مشتری هنگام ثبت سفارش جدید
- تنظیم جداگانه برای فعال‌سازی پیام ثبت سفارش

### امکانات نسخه 2.0.0

#### تب وبسرویس
- فعال/غیرفعال کردن وب‌سرویس
- تنظیم آدرس API (پیش‌فرض: http://localhost:8000/api/v1/send)
- توکن Authorization

#### تب پیام به مدیر کل
- فعال/غیرفعال ارسال به مدیر
- شماره واتساپ مدیر
- انتخاب وضعیت‌های سفارش برای ارسال پیام
- پیام اختصاصی برای هر وضعیت سفارش
- پیام کم بودن موجودی انبار
- پیام تمام شدن موجودی انبار

#### تب پیام به مشتری
- فعال/غیرفعال ارسال به مشتری
- **فعال/غیرفعال ارسال پیام ثبت سفارش**: ارسال پیام فوری هنگام ثبت سفارش جدید
- **پیام ثبت سفارش**: متن پیام مخصوص ثبت سفارش (مثلاً "سفارش شما ثبت شد")
- انتخاب وضعیت‌های سفارش برای ارسال پیام
- پیام اختصاصی برای هر وضعیت سفارش

#### تب تست ارسال
- ارسال پیام تست با شماره و متن دلخواه
- محدودیت: یک پیام در هر دقیقه

### شورت کدهای قابل استفاده

#### جزئیات سفارش
- `{mobile}` - شماره موبایل مشتری
- `{phone}` - شماره تلفن مشتری
- `{email}` - ایمیل مشتری
- `{status}` - وضعیت سفارش
- `{all_items}` - محصولات سفارش
- `{all_items_full}` - محصولات با نام کامل متغیر
- `{all_items_qty}` - محصولات بهمراه تعداد
- `{count_items}` - تعداد محصولات
- `{price}` - مبلغ سفارش
- `{post_id}` - شماره سفارش اصلی
- `{order_id}` - شماره سفارش
- `{transaction_id}` - شماره تراکنش
- `{date}` - تاریخ سفارش
- `{description}` - توضیحات مشتری
- `{payment_method}` - روش پرداخت
- `{shipping_method}` - روش ارسال

#### جزئیات صورت حساب
- `{b_first_name}` - نام
- `{b_last_name}` - نام خانوادگی
- `{b_company}` - شرکت
- `{b_country}` - کشور
- `{b_state}` - استان
- `{b_city}` - شهر
- `{b_address_1}` - آدرس 1
- `{b_address_2}` - آدرس 2
- `{b_postcode}` - کد پستی

#### جزئیات حمل و نقل
- `{sh_first_name}` - نام
- `{sh_last_name}` - نام خانوادگی
- `{sh_company}` - شرکت
- `{sh_country}` - کشور
- `{sh_state}` - استان
- `{sh_city}` - شهر
- `{sh_address_1}` - آدرس 1
- `{sh_address_2}` - آدرس 2
- `{sh_postcode}` - کد پستی

#### اطلاعات رهگیری
- `{post_tracking_code}` - کد رهگیری پستی
- `{post_tracking_url}` - آدرس رهگیری پستی

#### شورت کدهای موجودی (فقط برای پیام‌های موجودی)
- `{product_name}` - نام محصول
- `{product_id}` - شناسه محصول
- `{product_sku}` - کد SKU
- `{stock_qty}` - موجودی فعلی
- `{product_price}` - قیمت محصول

## نصب

1. پوشه افزونه را در `wp-content/plugins/` قرار دهید
2. افزونه را از بخش افزونه‌ها فعال کنید
3. مطمئن شوید WooCommerce فعال است

## تنظیمات

### مسیرهای دسترسی:
- **تنظیمات کلی**: ووکامرس > تنظیمات > اتصال به واتساپ ووکامرس
- **پیکربندی پیشرفته**: ووکامرس > پیکربندی واتساپ وااپ

### راه‌اندازی گام به گام:

1. **تنظیمات وب‌سرویس**: ووکامرس > پیکربندی واتساپ > تب وبسرویس
   - فعال‌سازی وب‌سرویس
   - تنظیم آدرس API (مثال: `http://localhost:8000/api/v1/send`)
   - تنظیم توکن Authorization

2. **پیام به مشتری**: تب پیام به مشتری
   - فعال‌سازی ارسال به مشتری
   - **برای ارسال پیام ثبت سفارش**: گزینه "ارسال پیام ثبت سفارش" را فعال کنید
   - پیام ثبت سفارش را بنویسید (مثال: "سفارش شما با شماره {order_id} ثبت شد")
   - وضعیت‌های مورد نظر را انتخاب کنید
   - متن پیام با شورت کدها را برای هر وضعیت بنویسید

3. **پیام به مدیر**: تب پیام به مدیر کل
   - فعال‌سازی ارسال به مدیر
   - تنظیم شماره واتساپ مدیر
   - انتخاب وضعیت‌های سفارش و پیام‌های موجودی

## پیش‌نیازها
- WordPress 5.0+
- WooCommerce 3.0+
- PHP 7.2+

## ساختار API

درخواست POST به آدرس تنظیم شده:

```bash
curl -X POST http://localhost:8000/api/v1/send \
  -H "Authorization: Bearer YOUR_API_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"phone": "989123456789", "message": "پیام شما"}'
```

## توسعه‌دهنده
احمد حسینی

## نسخه
2.0.0